/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPCONFIGDIB_H
#define QKNXNETIPCONFIGDIB_H

#include <QtKnx/qtknxglobal.h>
#include <QtKnx/qknxnetipstruct.h>
#include <QtNetwork/qhostaddress.h>

QT_BEGIN_NAMESPACE

class Q_KNX_EXPORT QKnxNetIpConfigDibProxy final
{
public:
    QKnxNetIpConfigDibProxy() = delete;
    ~QKnxNetIpConfigDibProxy() = default;

    QKnxNetIpConfigDibProxy(const QKnxNetIpDib &&) = delete;
    explicit QKnxNetIpConfigDibProxy(const QKnxNetIpDib &dib);

    bool isValid() const;
    QKnxNetIp::DescriptionType descriptionType() const;

    QHostAddress ipAddress() const;
    QHostAddress subnetMask() const;
    QHostAddress defaultGateway() const;
    QKnxNetIp::Capabilities capabilities() const;
    QKnxNetIp::AssignmentMethods assignmentMethods() const;

    class Q_KNX_EXPORT Builder final
    {
    public:
        Builder &setIpAddress(const QHostAddress &ipAddress);
        Builder &setSubnetMask(const QHostAddress &subnetMask);
        Builder &setDefaultGateway(const QHostAddress &gateway);
        Builder &setCapabilities(QKnxNetIp::Capabilities capabilities);
        Builder &setAssignmentMethods(QKnxNetIp::AssignmentMethods methods);

        QKnxNetIpDib create() const;

    private:
        QHostAddress m_ipAddress;
        QHostAddress m_subnetMask;
        QHostAddress m_gateway;
        QKnxNetIp::Capabilities m_caps { QKnxNetIp::Capability::Unknown };
        QKnxNetIp::AssignmentMethods m_methods { QKnxNetIp::AssignmentMethod::Unknown };
    };
    static QKnxNetIpConfigDibProxy::Builder builder();

private:
    const QKnxNetIpDib &m_dib;
};

QT_END_NAMESPACE

#endif
